this.name					= "nullgates_gateTrader";
this.author					= "Thargoid";
this.copyright				= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt.";
this.description				= "Script for traders using jumpgates";
this.version				= "1.02";

"use strict";

this.shipSpawned = function()
{
	if(system.isInterstellarSpace || system.sun.isGoingNova || system.sun.hasGoneNova || system.countShipsWithRole("nullgates") < 1) return;

	function nullGates(entity) {return entity.isShip && entity.hasRole("nullgates")}; // all gates except this one
	var ngates = system.filteredEntities(this, nullGates, this.ship); // find the gates in the system

	if(this.ship.position.distanceTo(ngates[0].position) < 51200 && (this.ship.AIState == "HEAD_FOR_PLANET" || this.ship.AIState == "HEAD_FOR_SUN" || this.ship.AIState == "HEAD_AWAY_FROM_PLANET")) {
		this.ship.target = ngates[0];
		this.ship.setAI("nullgates_useGateAI.plist");
	}
}

this.$checkGateDistance = function()
{	
	if(this.ship.position.distanceTo(this.ship.target.position) > 51200) {
		this.ship.reactToAIMessage("NEXT_GATE")
	}
}